
// Neurosis Engine - LP23.com
// Copyright  Luigi Pino. All rights reserved.

/***************************************************************************/

#ifndef _NEUROSIS_ENGINE_BASE64_H_
#define _NEUROSIS_ENGINE_BASE64_H_

/***************************************************************************/

class CNeurosisBase64 {
	public:
		CNeurosisBase64();
		//! Constructor/Deconstructor
		~CNeurosisBase64();

		// Decode
		static unsigned long	Decode(void *dest, const void *src, unsigned long size);
		//! Length of decoded string
		static unsigned long	Decode_Get_Length(unsigned long size);
		//! Decode string
		static CString				Decode_String(const char *stringEncoded, ...);
		//! Encode
		static unsigned long	Encode(void *dest, const void *src, unsigned long size);
		//! Length of encoded string
		static unsigned long	Encode_Get_Length(unsigned long size);
		//! Encode string
		static CString				Encode_String(const char *stringDecoded, ...);
};

/***************************************************************************/
#endif